/*
   konq_rellinks.h
   A plugin to display document relation links in konquerors menus/toolbars

   begin:  Sun Jan 20 15:34:41 CET 2002
   author: Anders Lund, anders@alweb.dk, copyright 2002
   new-begin: Apr 1st CET 2003
   new-author: Franck Qulain, franck.quelain@laposte.net, copyright 2003
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef _KONQ_RELLINKS_H_
#define _KONQ_RELLINKS_H_

/*
   This plugin queries the current HTML docyment for LINK elements, and if
   any found which has a REL property which is not "stylesheet", it creates
   a action to activate the link.

   This action will be in the Tools/Related submenu. The text for the action
   will be <REL>: <TEXT> where <REL> is the contents of that property in the link.
   The <TEXT> is either the TITLE property of the link, or if none the HREF property.

   TODO
   This should go into Konqueror/khtmlpart itself, so that the most common links could
   get shortcuts of their own, next = ctrl + next, up = ctrl + up etc.
*/

#include <kparts/plugin.h>
#include <dom/dom_string.h>
#include <qmap.h>

typedef QMap<int,KURL> KURLMap;

class KActionMenu;
class KURL;

class KonqRellinks : public KParts::Plugin {
  Q_OBJECT
  public:
    KonqRellinks( QObject *parent, const char *name, const QStringList & );
    virtual ~KonqRellinks();

  private slots:
    void updateToolbar();

    void goToLink(QString);
    void goHome();
    void goUp();
    void goFirst();
    void goPrevious();
    void goNext();
    void goLast();
    void goContents();
    void goIndex();
    void goGlossary();
    void goHelp();
    void goSearch();
    void goCopyright();
    void goAuthor();

    void goToLink(QString link, int id);
    void goBookmark(int id);
    void goChapter(int id);
    void goSection(int id);
    void goSubsection(int id);
    void goAppendice(int id);
    void goAlternate(int id);
    void goAllElements(int id);

    void changeConf(int i);

  private:
    void desactivateAll();

    KSimpleConfig *kconfig;
    static const QString CONF_ALWAYS;
    static const QString CONF_NEVER;
    static const QString CONF_WHEN_NECESSARY;
    QStringList listitem_conf;

    KSelectAction *m_conf;
    KActionMenu *m_document;
    KActionMenu *m_chapters;
    KActionMenu *m_sections;
    KActionMenu *m_subsections;
    KActionMenu *m_appendices;

    KActionMenu *m_more;
    KActionMenu *m_bookmarks;
    KActionMenu *m_other_versions;

    QString m_url;

    QMap<QString,KAction*> kaction_map;
    QMap<QString,KActionMenu*> kactionmenu_map;

    QMap<QString,KURL> url_map;
    QMap<QString,KURLMap> menu_url_map;


};

#endif // _KONQ_RELLINKS_H_
