<?php
# ***** BEGIN LICENSE BLOCK *****
# This file is part of DotClear.
# Copyright (c) 2004 Olivier Meunier and contributors. All rights
# reserved.
#
# DotClear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DotClear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with DotClear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#eze
# ***** END LICENSE BLOCK *****
#
# Contributor : Qulain Franck (http://shift.free.fr/)
#

/* All PHP errors are reported */
//error_reporting(E_ALL);

/* Function to protect double quotes of html args */
function protectDoubleQuote($text) {
	return str_replace('"', '&quot;', $text);
}

# User acronyms file
$acronyms_file_name = dirname(__FILE__).'/../../../share/wiki-acronyms-user.txt';
$exists = file_exists($acronyms_file_name);
$is_readable = is_readable($acronyms_file_name);
$is_writable = is_writable($acronyms_file_name);

# Error management
$err = "";

/* Action management 
----------------------------------------------------- */

## Add action

if(!empty($_REQUEST['add'])) {
	// User click on "add" button

	$newKey = $_REQUEST['newAcronym'];
	$newValue = $_REQUEST['newAcronymValue'];

	if (!$acronyms_file_for_append = fopen($acronyms_file_name, 'a')) {
 		$err =	__("Can't add this acronym. Error during opening the acronyms file.");
  }
	else {
		
  	if (fwrite($acronyms_file_for_append, "\n".$newKey." : ".$newValue."\n") === FALSE) {
  	$err =	__("Can't add this acronym. Error during writing to the acronyms file.");
  	}
	}
	fclose($acronyms_file_for_append);
}

## Modify action

if(!empty($_REQUEST['modify'])) {
	// User click on "modify" button

	if (!$acronyms_file_for_write = fopen($acronyms_file_name, 'w+')) {
		$err =	__("Error during opening the acronyms file in writing mode.");
  }
	else {

		// Get all the acronyms on the request
		$acronyms = array();
		foreach($_REQUEST as $requestKey => $value) {
			$prefix = substr($requestKey, 0, 8);
		
			if($prefix == "acronym-" && trim($value) != "") {
				$key = substr($requestKey, 8);
				
				if(dc_encoding == 'UTF-8') {
					$acronyms[utf8_decode($key)] = utf8_decode(trim($value));
				} else {
					$acronyms[$key] = trim($value);
				}
	
			}
		}

		foreach($acronyms as $key => $value) {
	
			if (fwrite($acronyms_file_for_write, $key." : ".$value."\n") === FALSE) {
				$err =	__("Error during writing of the acronyms file.");
 		 	}

		}
  
		fclose($acronyms_file_for_write);
	}
}

/* Display the tool page 
----------------------------------------------------------- */

# List of the acronyms to display
$acronyms = array();
	
if(!$exists) {
	// If the user file acronyms doesn't exists, use the general one
	$acronyms_file_name = dirname(__FILE__).'/../../../share/wiki-acronyms.txt';
	$exists = file_exists($acronyms_file_name);
	$is_readable = is_readable($acronyms_file_name);
	$is_writable = is_writable($acronyms_file_name);
}

if($is_readable) {
	$acronyms_file = fopen($acronyms_file_name, "r");
	
	while (!feof($acronyms_file)) {
   	$line = fgets($acronyms_file, 4096);

		$position = strpos($line, ":");
		$key = trim(substr($line, 0, $position));
		$value = trim(substr($line, $position + 1));

		if($value != "") {
			if(dc_encoding == 'UTF-8') {
				$acronyms[utf8_encode($key)] = utf8_encode($value);
			} else {
				$acronyms[$key] = $value;
			}
		}
	}
	fclose($acronyms_file);
	
	// Sort by key
	ksort($acronyms);
}

/* Display
----------------------------------------------------------*/

buffer::str(
	'<h2>'.__('Acronyms manager').'</h2>'
);

if($err != '') {
  buffer::str(
  	'<div class="erreur"><p><strong>'.__('Error(s)').' :</strong></p>'.$err.
		'</div>'
	);
}

buffer::str(
	'<h3>'.__('Defineds acronyms').'</h3>'
);

if ($exists && !$is_readable)
{
	buffer::str(
	'<p>'.sprintf(__('The file %s is not readable, Please check its permissions.'),
	'/share/wiki-acronyms-user.txt').'</p>'
	);
}
else
{
	// Form
	buffer::str(
	'<form action="tools.php" method="post">'.
	'<p>'.
	'<input type="hidden" name="p" value="acronyms" />'.
	'</p>'.
	'<div style="height:200px;width:100%;overflow:auto">'
	);


	// Acronym modifying inputs
	foreach ($acronyms as $k => $v) {

		buffer::str(
			'<p class="field">'.
			'<label class="float" style="width:20%" for="acronym-'.$k.'">'.$k.'</label>'.
			'<input id="acronym-'.$k.'" name="acronym-'.$k.'" type="text" value="'.protectDoubleQuote($v).'" style="width:75%"/>'.
			'</p>'
		);
	}

	// Modify button
	buffer::str(
		'</div>'.
		'<p>'.
		'<input type="submit" name="modify" class="submit" value="'.__('modify').'" />'.
		' ('.__('To remove one of the acronym, just empty its definition').')'.
		'</p>'
	);

	// Add an acronym
	buffer::str(
		'<h3>'.__('Add an acronym').'</h3>'
	);

	if ($exists && !$is_writable) {
		buffer::str(
			'<p>'.sprintf(__('The file %s is not writable, Please check its permissions.'),
			'/share/wiki-acronyms-user.txt').'</p>'
		);
	}
	else {
		buffer::str(
			'<p>'.
			'<label for="newAcronym">'.__('Acronym').'</label>'.
			'<input name="newAcronym" value="" />'.
			'<label for="newAcronymValue">'.__('Description').'</label>'.
			'<input name="newAcronymValue" value="" />'.
			'</p>'.
			'<p>'.
			'<input type="submit" name="add" class="submit" value="'.__('add').'" />'.
			'</p>'
		);

	}
	
	buffer::str(
		'</form>'
	);

}
?>
